# About the Examples


## Welcome

You found the examples! This sample code provides you simple, bite-sized examples for core classes and base addons that come with openFrameworks. Listed below are the primary categories the examples are organized into.

* [3D](3d/)
* [Android](android/)
* [Communication](communication/)
* [Computer Vision](computer_vision/)
* [Events](events/)
* [OpenGL](gl/)
* [OpenGLES](gles/)
* [Graphics](graphics/)
* [GUI](gui/)
* [Input / Output](input_output/)
* [iOS](ios/)
* [Math](math/)
* [Shader](shader/)
* [Sound](sound/)
* [Strings](strings/)
* [tvOS](tvOS/)
* [Templates](templates/)
* [Threads](threads/)
* [Windowing](windowing/)
* [Video](video/)

## Getting Started

Each of these categories contains examples primarily built to showcase an element of openFrameworks around that topic. Examples are meant to be as simple as possible, helping you understand how to implement either a function/method within the openFrameworks, or elaborate on an existing algorithm. Useful categories to get started might include:

### [Graphics](graphics/)

A storehouse of interesting, whimsical, and utilitarian approaches to drawing things on screen in your openFrameworks application. Examples here range from drawing simple shapes, rendering text with fonts, and setting color and blending modes.

### [Input / Output](input_output/)

Learn how to load files, data, and settings into your applications. Furthermore, learn how to take that fun interaction you made and export it in an interesting way.


## Want to Contribute?

Have an elegant example or straight-forward snippet of code that explains a functionality of openFrameworks that doesn't yet exist? Perhaps you want to elaborate on the documentation, inline comments, or README? Come join us in making these examples as useful as possible.

* **[Examples Documentation and Creation Flow](https://github.com/openframeworks/openFrameworks/wiki/Examples-Contribution-Process-Flow)**
