﻿[openFrameworks](http://openframeworks.cc/) | [Documentation table of contents](table_of_contents.md)

Libraries
=========

openFrameworks uses a mix of the following libraries, depending on your platform.  
Find those in `libs/` folder.

[Assimp](http://assimp.sourceforge.net/)
--------
* Graphics
* BSD

Open Asset Import Library is a portable Open Source library to import various well-known 3D model formats in a uniform manner.

[Cairo](http://cairographics.org/)
-------
* Graphics
* LGPL v2.1

Cairo is a 2D graphics library with support for multiple output devices.

[FMOD](http://www.fmod.org/)
------
* Audio
* FMOD License

[FreeImage](http://freeimage.sourceforge.net/)
-----------
* Image
* GPLv3, FIPL

FreeImage is an Open Source library project for developers who would like to support popular graphics image formats like PNG, BMP, JPEG, TIFF and others as needed by today's multimedia applications.

[FreeType](http://www.freetype.org/)
----------
* Fonts
* GPLv2, FTL

FreeType designed to be small, efficient, highly customizable, and portable while is capable of producing high-quality output (glyph images) of most vector and bitmap font formats.

[GLEW](http://glew.sourceforge.net/)
------
* Graphics
* BDS, MIT

The OpenGL Extension Wrangler Library (GLEW) is a cross-platform open-source C/C++ extension loading library. GLEW provides efficient run-time mechanisms for determining which OpenGL extensions are supported on the target platform.

[GLUT](http://www.opengl.org/resources/libraries/glut/)
------
* Graphics
* -

GLUT is the OpenGL Utility Toolkit, a window system independent toolkit for writing OpenGL programs.

[GStreamer](http://gstreamer.freedesktop.org/)
-----------
* Video
* LGPL

Streamer is a library for constructing graphs of media-handling components.

[Kiss FFT](http://kissfft.sourceforge.net/)
----------
* Audio
* BSD

A Fast Fourier Transform based up on the principle, "Keep It Simple, Stupid." Kiss FFT is a very small, reasonably efficient, mixed radix FFT library that can use either fixed or floating point data types.

[Libtess2](https://code.google.com/p/libtess2/)
----------
* Graphics
* MIT

Game and tools oriented refactored version of GLU tesselator. 

[OpenGL](http://www.opengl.org/)
--------
* Graphics
* BSD

OpenGL (Open Graphics Library) is a cross-language, multi-platform API for rendering 2D and 3D computer graphics.

[Poco](http://pocoproject.org/)
------
* Utilities
* Boost Software License

Modern, powerful open source C++ class libraries and frameworks for building network- and internet-based applications that run on desktop, server, mobile and embedded systems. 

[PortAudio](http://www.portaudio.com/)
-----------
* Audio
* MIT

PortAudio is a free, cross-platform, open-source, audio I/O library.

[QuickTime](http://developer.apple.com/quicktime/)
-----------
* Video
* Apple Copyright

QuickTime and the QTKit framework provide powerful services for manipulating time-based media, allowing you to add audio and video playback, capture, and encoding capabilities to your application.

[rtAudio](http://www.music.mcgill.ca/~gary/rtaudio/)
---------
* Audio
* MIT

RtAudio is a set of C++ classes that provide a common API (Application Programming Interface) for realtime audio input/output across Linux, Macintosh OS-X and Windows operating systems.

[videoInput](https://github.com/ofTheo/videoInput)
------------
* Video
* MIT

A video capture library for Windows. 